package doABC.Cpool;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;

import doABC.CpoolInfo;
import doABC.Multiname.MultinameKindMultiname;
import doABC.Multiname.MultinameKindMultinameL;
import doABC.Multiname.MultinameKindQName;
import doABC.Multiname.MultinameKindRTQName;
import doABC.Multiname.MultinameKindRTQNameL;

import FlashReader.SWF;
import FlashReader.SwfTools;

public class MultinameInfo extends SwfTools{

	private int id;
	private CpoolInfo cpool;
	public static HashMap<Integer, String> multinameKind = new HashMap<Integer, String>();
	
	private int start=-1;
	private int end=-1;
	//struktury
	private int kind=-1;
	private Object data = null;
	
	public  MultinameInfo(CpoolInfo cpool, int kind, int id){
		super();
		getKind_string();
		this.cpool = cpool;
		this.kind= kind;
		this.data = new MultinameKindRTQName(cpool,0);
		this.id=id;
		
	}
	
	public  MultinameInfo(CpoolInfo cpool, MultinameKindQName data, int kind, int id){
		super();
		initKind();
		this.cpool = cpool;
		this.data=data;
		this.kind= kind;
		this.id=id;
	}
	public  MultinameInfo(CpoolInfo cpool, MultinameKindRTQName data, int kind, int id){
		super();
		initKind();
		this.cpool = cpool;
		this.data=data;
		this.kind= kind;
		this.id=id;
	}
	
	public  MultinameInfo(CpoolInfo cpool, MultinameKindRTQNameL data, int kind, int id){
		super();
		initKind();
		this.cpool = cpool;
		this.data=data;
		this.kind= 0x11;
		this.id=id;
	}
	
	public  MultinameInfo(CpoolInfo cpool, MultinameKindMultiname data, int kind, int id){
		super();
		initKind();
		this.cpool = cpool;
		this.data=data;
		this.kind= kind;
		this.id=id;
	}
	
	public  MultinameInfo(CpoolInfo cpool, MultinameKindMultinameL data, int kind, int id){
		super();
		initKind();
		this.cpool = cpool;
		this.data=data;
		this.kind= kind;
		this.id=id;
	}
	
	public void setKind(int kind) {
		this.kind = kind;
	}

	public void setData(Object data) {
		this.data = data;
	}

	public int getKind() {
		return kind;
	}

	public  MultinameInfo(ByteBuffer bbuf, CpoolInfo cpool, int id){
		super();
		initKind();
		this.cpool = cpool;
		multiname_info(bbuf);
		this.id=id;
	}
	
	
	private void multiname_info(ByteBuffer bbuf){

		start = bbuf.position();
		
		kind = unsignedByte(bbuf.get());
		
		if (kind ==0x07 || kind == 0x0D )
			data=new MultinameKindQName(bbuf,cpool);
		else if( kind ==0x0F || kind == 0x10 )
			data=new MultinameKindRTQName(bbuf,cpool);
		else if( kind == 0x11 || kind == 0x12 )
			data=new MultinameKindRTQNameL(bbuf);
		else if( kind == 0x09 || kind ==0x0E )
			data=new MultinameKindMultiname(bbuf,cpool);
		else if(kind == 0x1B || kind == 0x1C )
			data=new MultinameKindMultinameL(bbuf,cpool);
		
		end = bbuf.position()-1;
	}

	//getters
	
	public String getKind_string() {
		return multinameKind.get(kind);
	}
	
	public static int getFlags(String flags) {
		return (Integer)getKeyFromValue(multinameKind, flags);
	}

	
	public int getStart() {
		return start;
	}


	public int getEnd() {
		return end;
	}
	
	public int getId() {
		return id;
	}


	public String String(){
		String wynik ="";
		wynik+="\n---#--- ns_set_info "+SWF.msgs.getString("Position")+": " + start + "\n\n";
		
		wynik+= "kind: " + kind+"\n";
			
		wynik+= "data: " + getData()+"\n";
			
		wynik+="\n---!!--- "+SWF.msgs.getString("Position")+":  "+end;
		
		return wynik;
		
		
	}
	
	public String toString(){
		String wynik ="";
		wynik+=getData();
		return wynik;
	}


	public static HashMap<Integer, String> initKind() {
		multinameKind.put(0x07,"CONSTANT_QName" );
		multinameKind.put(0x0D,"CONSTANT_QNameA" );
		multinameKind.put(0x0F,"CONSTANT_RTQName" );
		multinameKind.put(0x10,"CONSTANT_RTQNameA" );
		multinameKind.put(0x11,"CONSTANT_RTQNameL" );
		multinameKind.put(0x12,"CONSTANT_RTQNameLA" );
		multinameKind.put(0x09,"CONSTANT_Multiname" );
		multinameKind.put(0x0E,"CONSTANT_MultinameA" );
		multinameKind.put(0x1B,"CONSTANT_MultinameL" );
		multinameKind.put(0x1C,"CONSTANT_MultinameLA" );
		return multinameKind;
	}


	public Object getData() {
		return data;
	}
	
	public ArrayList<Byte> toByteCode(){
		ArrayList<Byte> result = new ArrayList<Byte>();
		
		if (  kind!=-1){
			result.add((byte)kind);
		}
		
		if(data !=null){
			if (kind ==0x07 || kind == 0x0D ){
				for( byte b : ((MultinameKindQName)data).toByteCode())
					result.add(b);
		
			}
			else if( kind ==0x0F || kind == 0x10 ){
				for( byte b : ((MultinameKindRTQName)data).toByteCode())
					result.add(b);

			}
			else if( kind == 0x11 || kind == 0x12 ){
		
			}
			else if( kind == 0x09 || kind ==0x0E ){
				for( byte b : ((MultinameKindMultiname)data).toByteCode())
					result.add(b);
				
			}
			else if(kind == 0x1B || kind == 0x1C ){
				for( byte b : ((MultinameKindMultinameL)data).toByteCode())
					result.add(b);
				
				
			}
				
			
		}

		
		return result;
	}
	
	

}
